(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     21442,        576]
NotebookOptionsPosition[     19751,        518]
NotebookOutlinePosition[     20326,        538]
CellTagsIndexPosition[     20283,        535]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Lab 04 Vector-Valued Functions", "Title",
 CellChangeTimes->{{3.544798575870993*^9, 3.544798584388549*^9}, {
   3.576837003801124*^9, 3.5768370046704807`*^9}, 3.651493746368318*^9, {
   3.6514938359414587`*^9, 3.6514938508041162`*^9}}],

Cell["[Your name(s) here!]\[LineSeparator]", "Subsubsection",
 CellChangeTimes->{{3.651497308729217*^9, 3.65149731631071*^9}, {
  3.652027126570849*^9, 3.652027130578257*^9}}],

Cell[CellGroupData[{

Cell["Examples to steal from", "Subsubsection",
 CellChangeTimes->{{3.544798658907484*^9, 3.544798661461194*^9}, {
   3.544798754332018*^9, 3.5447989218883576`*^9}, {3.5447989541400585`*^9, 
   3.544799060659006*^9}, {3.5448012298042216`*^9, 3.544801243743148*^9}, {
   3.5448019260102797`*^9, 3.544801936666502*^9}, {3.5448250869858484`*^9, 
   3.5448250882049184`*^9}, 3.544825120804783*^9, {3.651493899154603*^9, 
   3.651493902227357*^9}, {3.651493934539884*^9, 3.65149396161467*^9}, {
   3.6835536709314547`*^9, 3.6835536759699917`*^9}}],

Cell[TextData[{
 StyleBox["Here are examples of some of the kinds of things you\
\[CloseCurlyQuote]ll do in this lab.\[LineSeparator]\[LineSeparator]",
  FontColor->GrayLevel[0]],
 StyleBox["Plotting a parametric vector function:",
  FontWeight->"Bold",
  FontColor->GrayLevel[0]],
 StyleBox["\n\nThis is really a vector function ",
  FontColor->GrayLevel[0]],
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["r", "\[RightVector]"], "(", "t", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontColor->GrayLevel[0]],
 " where the vector is a position vector. ",
 StyleBox[" It\[CloseCurlyQuote]s got 3 functions for x(t), y(t), and z(t) in \
its declaration, But I\[CloseCurlyQuote]m going to risk a little clarity by \
writing it without bothering to put the vector over top...",
  FontColor->GrayLevel[0]]
}], "Text",
 CellChangeTimes->{{3.6520271497171717`*^9, 3.652027157823184*^9}, {
   3.652028746212903*^9, 3.652028881973608*^9}, {3.6835536803463383`*^9, 
   3.6835537845209513`*^9}, 3.683553846600175*^9, {3.683554897790531*^9, 
   3.6835548986127777`*^9}, {3.683554936331231*^9, 3.683554960315132*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "[", "t_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"t", ",", 
    RowBox[{"t", " ", 
     RowBox[{"Sin", "[", "t", "]"}]}], ",", 
    RowBox[{"t", " ", 
     RowBox[{"Cos", "[", "t", "]"}]}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"r", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"8", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.652033704909889*^9, 3.652033712632946*^9}, {
  3.6835512894340277`*^9, 3.68355133627181*^9}, {3.683552106267267*^9, 
  3.683552190084282*^9}, {3.68355226769261*^9, 3.683552300970936*^9}, {
  3.683552351690785*^9, 3.6835523538022614`*^9}}],

Cell[TextData[StyleBox["\[LineSeparator]\[LineSeparator]Displaying a point on \
the curve, together with the derivative vector at that point.",
 FontWeight->"Bold"]], "Text",
 CellChangeTimes->{{3.683553889480596*^9, 3.683553916831111*^9}, {
  3.6835539476074963`*^9, 3.6835539478154497`*^9}, {3.683554116851383*^9, 
  3.683554118508759*^9}}],

Cell[BoxData[
 RowBox[{"Show", "[", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"r", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"8", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", "       ", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Big", " ", "red", " ", "dot", " ", "at", " ", 
       RowBox[{"r", "[", 
        RowBox[{"t", "=", 
         RowBox[{"3.5", " ", "\[Pi]"}]}], "]"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", ".04", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"r", "[", 
        RowBox[{"3.5", " ", "\[Pi]"}], "]"}], "]"}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"Arrow", "[", " ", "]"}], " ", "requires", " ", 
         "coordinates", " ", "of", " ", "tail"}], ",", " ", 
        RowBox[{"then", " ", "head"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      " ", 
      RowBox[{"Arrow", "[", " ", 
       RowBox[{"{", "   ", 
        RowBox[{
         RowBox[{"r", "[", 
          RowBox[{"3.5", " ", "\[Pi]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"r", "[", 
           RowBox[{"3.5", "\[Pi]"}], "]"}], "+", 
          RowBox[{
           RowBox[{"r", "'"}], "[", 
           RowBox[{"3.5", " ", "\[Pi]"}], "]"}]}]}], "  ", "}"}], " ", 
       "]"}]}], " ", "\[IndentingNewLine]", "}"}], "   ", "]"}]}], "    ", 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.683552310930922*^9, 3.683552318706341*^9}, {
  3.6835523721166983`*^9, 3.683552390001994*^9}, {3.683552428804638*^9, 
  3.683552469873155*^9}, {3.683552596848806*^9, 3.683552852270893*^9}, {
  3.683552885789526*^9, 3.6835530812904387`*^9}, {3.683553927959997*^9, 
  3.68355393339183*^9}}],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]",
 StyleBox["Animating the \[OpenCurlyDoubleQuote]particle\
\[CloseCurlyDoubleQuote]",
  FontWeight->"Bold"]
}], "Text",
 CellChangeTimes->{{3.683554013662746*^9, 3.683554022533763*^9}}],

Cell[BoxData[
 RowBox[{"Animate", " ", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Show", "[", " ", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"r", "[", "k", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", 
         RowBox[{"8", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics3D", "[", "       ", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Big", " ", "red", " ", "dot", " ", "at", " ", 
         RowBox[{"r", "[", 
          RowBox[{"t", "=", 
           RowBox[{"3.5", " ", "\[Pi]"}]}], "]"}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", ".04", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"r", "[", "t", "]"}], "]"}], ",", " ", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "Arrows", " ", "require", " ", "coordinates", " ", "of", " ", 
           "tail"}], ",", " ", 
          RowBox[{"then", " ", "head"}]}], " ", "*)"}], "\[IndentingNewLine]",
         " ", 
        RowBox[{"Arrow", "[", " ", 
         RowBox[{"{", "   ", 
          RowBox[{
           RowBox[{"r", "[", "t", "]"}], ",", 
           RowBox[{
            RowBox[{"r", "[", "t", "]"}], "+", 
            RowBox[{
             RowBox[{"r", "'"}], "[", "t", "]"}]}]}], "  ", "}"}], " ", 
         "]"}]}], " ", "\[IndentingNewLine]", "}"}], "   ", "]"}]}], "    ", 
    "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"8", " ", "\[Pi]"}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.6835531141144953`*^9, 3.683553170928845*^9}, {
  3.6835533468087673`*^9, 3.683553351676571*^9}, {3.683554052444697*^9, 
  3.683554073775023*^9}}],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]",
 StyleBox["Speed",
  FontWeight->"Bold"],
 ":  Speed is the magnitude (or \[OpenCurlyDoubleQuote]norm\
\[CloseCurlyDoubleQuote]) of the derivative vector:  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "'"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "(t) |.  Here\[CloseCurlyQuote]s how you can graph the (scalar) speed as a \
function of time:"
}], "Text",
 CellChangeTimes->{{3.6835542696193457`*^9, 3.68355430219855*^9}, {
  3.6835546163942423`*^9, 3.6835546193448477`*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", "     ", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"r", "'"}], "[", "t", "]"}], "]"}], "     ", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"8", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.683553261343405*^9, 3.683553298103207*^9}, {
  3.683554603025581*^9, 3.683554606028777*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]Exercise 1", "Subsubsection",
 CellChangeTimes->{{3.544798658907484*^9, 3.544798661461194*^9}, {
   3.544798754332018*^9, 3.5447989218883576`*^9}, {3.5447989541400585`*^9, 
   3.544799060659006*^9}, {3.5448012298042216`*^9, 3.544801243743148*^9}, {
   3.5448019260102797`*^9, 3.544801936666502*^9}, {3.5448250869858484`*^9, 
   3.5448250882049184`*^9}, 3.544825120804783*^9, {3.651493899154603*^9, 
   3.651493902227357*^9}, {3.651493934539884*^9, 3.65149396161467*^9}, {
   3.68355508642627*^9, 3.68355508695405*^9}}],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"{", 
   RowBox[{"E", ",", "e"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.683571240808386*^9, 3.683571255519658*^9}}],

Cell[TextData[{
 StyleBox["4 pts ",
  FontColor->RGBColor[1, 0, 0]],
 "Consider the two arcs ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["a",
       FontWeight->"Bold"], "(", "t", ")"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["e", "t"], "sin", " ", "t"}], ",", 
       RowBox[{
        SuperscriptBox["e", "t"], "cos", " ", "t"}], ",", " ", 
       SuperscriptBox["e", "t"]}], "\[RightAngleBracket]"}]}], ",", 
    RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", 
     RowBox[{"2", "\[Pi]"}]}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["b",
       FontWeight->"Bold"], "(", 
      StyleBox["t",
       FontWeight->"Plain"], ")"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"t", " ", 
        RowBox[{"sin", "(", 
         RowBox[{"ln", " ", "t"}], ")"}]}], ",", 
       RowBox[{"t", " ", 
        RowBox[{"cos", "(", 
         RowBox[{"ln", " ", "t"}], ")"}]}], ",", "t"}], 
      "\[RightAngleBracket]"}]}], ",", 
    RowBox[{"1", "\[LessEqual]", "t", "\[LessEqual]", 
     SuperscriptBox["e", 
      RowBox[{"2", "\[Pi]"}]]}]}], TraditionalForm]]],
 ".  [In Mathematica, type ",
 StyleBox["E",
  FontFamily->"Lucida Console",
  FontWeight->"Regular",
  FontColor->RGBColor[0.0025177386129549098`, 0.5931181811245899, 0.]],
 " (not  ",
 StyleBox["e",
  FontFamily->"Lucida Console",
  FontWeight->"Regular",
  FontColor->RGBColor[
   0.7463645380331121, 0.0635080491340505, 0.09872587167162584]],
 ") to get the base of the natural logarithm.] Plot both space curves and \
show that they trace out identical curves.  You can display two plots sides \
by enclosing them in list brackets, like { ParametricPlot3d[...], \
ParametricPlot3d[...]  }.\n"
}], "Text",
 CellChangeTimes->{{3.651493970578598*^9, 3.651494024330627*^9}, 
   3.651494109699737*^9, {3.652027015307132*^9, 3.652027108024844*^9}, {
   3.652028115501083*^9, 3.6520281341161823`*^9}, {3.658589024434474*^9, 
   3.658589026724177*^9}, {3.683551918889337*^9, 3.6835519261594057`*^9}, {
   3.683553539444109*^9, 3.683553639178998*^9}, 3.683553767212109*^9, {
   3.683553815618168*^9, 3.683553822781755*^9}, {3.6835541422846622`*^9, 
   3.6835542279834623`*^9}, 3.683570847852413*^9, {3.683571048376392*^9, 
   3.68357114244106*^9}, {3.6835711903044767`*^9, 3.683571213168046*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2", "Subsubsection",
 CellChangeTimes->{{3.544798658907484*^9, 3.544798661461194*^9}, {
   3.544798754332018*^9, 3.5447989218883576`*^9}, {3.5447989541400585`*^9, 
   3.544799060659006*^9}, {3.5448012298042216`*^9, 3.544801243743148*^9}, {
   3.5448019260102797`*^9, 3.544801936666502*^9}, {3.5448250869858484`*^9, 
   3.5448250882049184`*^9}, 3.544825120804783*^9, {3.651493899154603*^9, 
   3.651493902227357*^9}, {3.651493934539884*^9, 3.65149396161467*^9}, {
   3.651494241894363*^9, 3.651494242244872*^9}}],

Cell[TextData[{
 StyleBox["6 pts ",
  FontColor->RGBColor[1, 0, 0]],
 "In order to examine how a particle moves according to each function, create \
an animation of each like this:  First create a display of the arc and a \
large dot located at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["r",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
 ". Then \[OpenCurlyDoubleQuote]",
 StyleBox["Manipulate[..]",
  FontFamily->"Courier New"],
 "\[CloseCurlyDoubleQuote] the plot to move the dot as ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 " is varied with a slider.  Finally substitute ",
 StyleBox["Animate",
  FontFamily->"Courier New"],
 " for ",
 StyleBox["Manipulate",
  FontFamily->"Courier New"],
 ". This will change ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 " at a constant rate.  (See if you can get the derivative vector to show as \
well).\[LineSeparator]\[LineSeparator]Comment on differences that you observe \
between the two arc functions."
}], "Text",
 CellChangeTimes->{{3.651493970578598*^9, 3.651494024330627*^9}, 
   3.651494109699737*^9, {3.65149424626432*^9, 3.651494291377787*^9}, {
   3.651494329621722*^9, 3.651494486236022*^9}, {3.6514951492879477`*^9, 
   3.651495485527918*^9}, 3.651496747128397*^9, {3.6514968963885937`*^9, 
   3.651496952378826*^9}, {3.651497154289707*^9, 3.6514971950711327`*^9}, {
   3.658589042306472*^9, 3.6585890458533697`*^9}, {3.683554654544599*^9, 
   3.683554674142627*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[LineSeparator]Exercise 3", "Subsubsection",
 CellChangeTimes->{{3.544798658907484*^9, 3.544798661461194*^9}, {
   3.544798754332018*^9, 3.5447989218883576`*^9}, {3.5447989541400585`*^9, 
   3.544799060659006*^9}, {3.5448012298042216`*^9, 3.544801243743148*^9}, {
   3.5448019260102797`*^9, 3.544801936666502*^9}, {3.5448250869858484`*^9, 
   3.5448250882049184`*^9}, 3.544825120804783*^9, {3.651493899154603*^9, 
   3.651493902227357*^9}, {3.651493934539884*^9, 3.65149396161467*^9}, {
   3.6514955313892*^9, 3.651495531537491*^9}, 3.6835708031572647`*^9}],

Cell[TextData[{
 StyleBox["4 pts ",
  FontColor->RGBColor[1, 0, 0]],
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["a",
       FontWeight->"Bold"], "'"}], 
     RowBox[{"(", "t", ")"}]}], ",", " ", 
    RowBox[{"\[LeftBracketingBar]", 
     RowBox[{
      RowBox[{
       StyleBox["a",
        FontWeight->"Bold"], "'"}], 
      RowBox[{"(", "t", ")"}]}], "\[RightBracketingBar]"}]}], 
   TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["b",
       FontWeight->"Bold"], "'"}], 
     RowBox[{"(", "t", ")"}]}], ",", " ", 
    RowBox[{"and", " ", 
     RowBox[{"\[LeftBracketingBar]", 
      RowBox[{
       RowBox[{
        StyleBox["b",
         FontWeight->"Bold"], "'"}], 
       RowBox[{"(", "t", ")"}]}], "\[RightBracketingBar]"}]}]}], 
   TraditionalForm]]],
 ".  Graph the speeds. Describe how these results support (or challenge) the \
observations you made above.\n"
}], "Text",
 CellChangeTimes->{
  3.651495511319038*^9, {3.651495542159891*^9, 3.651495585856101*^9}, {
   3.6520287160962563`*^9, 3.6520287198353243`*^9}, {3.652033737261787*^9, 
   3.652033752164077*^9}, {3.658589059468811*^9, 3.658589062292676*^9}, {
   3.683554701136858*^9, 3.683554758821393*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4", "Subsubsection",
 CellChangeTimes->{{3.544798658907484*^9, 3.544798661461194*^9}, {
   3.544798754332018*^9, 3.5447989218883576`*^9}, {3.5447989541400585`*^9, 
   3.544799060659006*^9}, {3.5448012298042216`*^9, 3.544801243743148*^9}, {
   3.5448019260102797`*^9, 3.544801936666502*^9}, {3.5448250869858484`*^9, 
   3.5448250882049184`*^9}, 3.544825120804783*^9, {3.651493899154603*^9, 
   3.651493902227357*^9}, {3.651493934539884*^9, 3.65149396161467*^9}, {
   3.6514955313892*^9, 3.651495531537491*^9}, {3.651495623916123*^9, 
   3.651495624216703*^9}}],

Cell[TextData[{
 StyleBox["10 pts ",
  FontColor->RGBColor[1, 0, 0]],
 "Use Mathematica to calculate the arc length separately for each vector \
function. Use the formulae we developed in class, which involves integrating \
the \[OpenCurlyDoubleQuote]speed\[CloseCurlyDoubleQuote]... "
}], "Text",
 CellChangeTimes->{{3.5448010045256853`*^9, 3.5448010251931343`*^9}, {
   3.5448012800206976`*^9, 3.544801303231429*^9}, {3.5448016385893407`*^9, 
   3.5448017733945312`*^9}, 3.5448019893719177`*^9, {3.5448020215425053`*^9, 
   3.5448020479505725`*^9}, {3.5448262569677677`*^9, 3.544826263403136*^9}, {
   3.651495640681879*^9, 3.651495683953246*^9}, {3.6520290202667847`*^9, 
   3.652029026653111*^9}, {3.658589070753998*^9, 3.658589074066152*^9}, {
   3.683554803157956*^9, 3.683554819868559*^9}, {3.683555022235536*^9, 
   3.683555041762027*^9}, {3.683555120979703*^9, 3.683555154840557*^9}, {
   3.683569689470482*^9, 3.683569713353695*^9}, {3.683569751929275*^9, 
   3.6835699184286346`*^9}, {3.683569983185995*^9, 3.68357001113034*^9}, {
   3.68357011860841*^9, 3.6835701412093554`*^9}, {3.683570197116322*^9, 
   3.683570208276367*^9}, 3.683570383580489*^9, {3.683570421722621*^9, 
   3.683570435857621*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{"L", "=", 
         RowBox[{
          SubsuperscriptBox["\[Integral]", "a", "b"], 
          RowBox[{
           RowBox[{"\[LeftBracketingBar]", 
            RowBox[{
             RowBox[{
              OverscriptBox["r", "\[RightVector]"], "'"}], 
             RowBox[{"(", "t", ")"}]}], "\[RightBracketingBar]"}], 
           RowBox[{"\[DifferentialD]", "t"}]}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.683570319678171*^9, 3.683570365876027*^9}}],

Cell[TextData[{
 "Calculate the arc-length using both ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "--they should agree if the space-curves are identical.\[LineSeparator]\
\[LineSeparator]And then use Mathematica\[CloseCurlyQuote]s built-in ",
 StyleBox["ArcLength[...]",
  FontFamily->"Lucida Console",
  FontWeight->"Regular"],
 " function using both ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " and see if that function gives the same result."
}], "Text",
 CellChangeTimes->{
  3.683570411348072*^9, {3.68357044632073*^9, 3.683570595375278*^9}, {
   3.683570660288217*^9, 3.683570663382552*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1008, 730},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.25, 1.25 Inherited],
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 28, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 241, 3, 114, "Title"],
Cell[666, 20, 175, 2, 73, "Subsubsection"],
Cell[CellGroupData[{
Cell[866, 26, 542, 7, 34, "Subsubsection"],
Cell[1411, 35, 1132, 24, 158, "Text"],
Cell[2546, 61, 772, 19, 66, "Input"],
Cell[3321, 82, 342, 5, 85, "Text"],
Cell[3666, 89, 1990, 49, 248, "Input"],
Cell[5659, 140, 237, 6, 85, "Text"],
Cell[5899, 148, 1971, 48, 326, "Input"],
Cell[7873, 198, 617, 16, 137, "Text"],
Cell[8493, 216, 380, 10, 39, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8910, 231, 606, 8, 190, "Subsubsection"],
Cell[9519, 241, 167, 4, 39, "Input"],
Cell[9689, 247, 2444, 65, 138, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12170, 317, 526, 7, 43, "Subsubsection"],
Cell[12699, 326, 1473, 36, 160, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14209, 367, 564, 7, 73, "Subsubsection"],
Cell[14776, 376, 1285, 43, 85, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16098, 424, 574, 8, 43, "Subsubsection"],
Cell[16675, 434, 1213, 19, 61, "Text"],
Cell[17891, 455, 683, 19, 47, "Text"],
Cell[18577, 476, 1146, 38, 109, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

